(function (window, $, undefined) {
	"use strict";

	console.log('Hello. admin, ad-rpm-booster.');

	$( "#tabs" ).tabs();
	if (_ad_rpm_booster['b_setting_page'])
	{
		$('#tabs [href="#tabs-setting"]').click();
	}



	$('.chk_b_activate').change(function(){
		if ($(this).prop('checked'))
		{
			$('.switch_b_activate_true').fadeIn();
		}
		else
		{
			$('.switch_b_activate_true').fadeOut();
		}
	}).change();



	function showBlockCtrl(){
		$('.fadeIn').removeClass('fadeIn');
		$('.fadeOut').removeClass('fadeOut');

		if ($('[name="ad_rpm_booster[plugin_type]"]').val() > 1)
		{
			$('.switch_plugin_type_2').addClass('fadeIn');
		}
		else
		{
			$('.switch_plugin_type_2').addClass('fadeOut');
		}

		if ($('[name="ad_rpm_booster[plugin_type]"]').val() > 0)
		{
			$('.switch_plugin_type_1').addClass('fadeIn');
		}
		else
		{
			$('.switch_plugin_type_1').addClass('fadeOut');
		}



		if ($('.chk_show_setting_detail_block').prop('checked'))
		{
			$('.SettingDetailBlock').addClass('fadeIn');
		}
		else
		{
			$('.SettingDetailBlock').addClass('fadeOut');
		}


		switch ($('.rdo_flg_view_ctrl:checked').val())
		{
		case 'T':
			$('.switch_flg_view_ctrl_t').addClass('fadeIn');
			$('.switch_flg_view_ctrl_d').addClass('fadeOut');
			break;
		case 'D':
			$('.switch_flg_view_ctrl_t').addClass('fadeIn');
			$('.switch_flg_view_ctrl_d').addClass('fadeIn');
			break;
		case 'F':
			$('.switch_flg_view_ctrl_t').addClass('fadeOut');
			$('.switch_flg_view_ctrl_d').addClass('fadeOut');
			break;
		}


		switch ($('.rdo_split_mode:checked').val())
		{
		case 'A':
			$('.switch_split_mode_a').addClass('fadeIn');
			$('.switch_split_mode_b').addClass('fadeOut');
			break;
		case 'B':
			$('.switch_split_mode_a').addClass('fadeOut');
			$('.switch_split_mode_b').addClass('fadeIn');
			break;
		}



		$('.fadeIn.fadeOut').removeClass('fadeIn');

		$('.fadeIn').fadeIn();
		$('.fadeOut').fadeOut();
	}



	$('.chk_show_setting_detail_block').change(function(){
		showBlockCtrl();
		return false;
	}).change();


	$('.rdo_flg_view_ctrl').click(function(){
		switch ($(this).val())
		{
		case 'T':
		case 'D':
			if ($('[name="ad_rpm_booster[plugin_type]"]').val() < 1)
			{
				alert('アクティベーションが無効のため「なし」以外は選択できません。');
				return false;
			}
			break;
		case 'F':
			break;
		}

		showBlockCtrl();
	});
	$('.rdo_flg_view_ctrl:checked').click();


	$('.rdo_split_mode').click(function(){
		switch ($(this).val())
		{
		case 'A':
			break;
		case 'B':
			if ($('[name="ad_rpm_booster[flg_all_option]"]').val() != 'T')
			{
				alert('トライアル版のため「ページ分割」は選択できません。');
				return false;
			}
			break;
		}

		showBlockCtrl();
	});
	$('.rdo_split_mode:checked').click();




	$('[name="ad_rpm_booster[scroll_text_style_set]"]').click(function(){
		var item = $(this).closest('label').find('.scrollTextBox span');
		var bgcolor = rgb2hex( item.css('backgroundColor') );

		$('[name="ad_rpm_booster[scroll_text_backgroud_color]"]').val(bgcolor);
	});




	$('[name="ad_rpm_booster[related_text_style_set]"]').click(function(){
		var item = $(this).closest('label').find('.related-link-item');

		var color = rgb2hex( item.find('span').css('color') );
		var bgcolor = rgb2hex( item.find('span').css('backgroundColor') );

		var color2 = rgb2hex( item.find('a').css('color') );

		$('[name="ad_rpm_booster[related_text_color]"]').val(color);
		$('[name="ad_rpm_booster[related_text_backgroud_color]"]').val(bgcolor);

		$('[name="ad_rpm_booster[related_link_text_color]"]').val(color2);
	});




	$('[name="ad_rpm_booster[readmore_text_style_set]"]').click(function(){
		var item = $(this).closest('label').find('.readmoreBtn');

		var color = rgb2hex( item.css('color') );
		var bgcolor = rgb2hex( item.css('backgroundColor') );

		$('[name="ad_rpm_booster[readmore_text_color]"]').val(color);
		$('[name="ad_rpm_booster[readmore_text_backgroud_color]"]').val(bgcolor);
	});





	$('.showHelpBtn').click(function(){
		$('.help-box').remove();

		var help_id = $(this).attr('href');
		var help_box_html = $(help_id).html();
		var item = $(this).closest('tr');

		item.after('<tr valign="top" class="help-box" style="display:none;"><td colspan="2"></td></tr>');

		$('.help-box td').html(help_box_html);
		$('.help-box').fadeIn(500);

		$('body,html').animate({scrollTop: item.offset().top - 60}, 300, 'swing');
		return false;
	});


	$('#ad_rpm_booster_form').on('click', '.hideHelpBtn', function(){
		var pos_top = $(this).closest('tr').prev().offset().top - 60;
		$('.help-box').fadeOut(500);

		$('body,html').animate({scrollTop: pos_top}, 300, 'swing');
		return false;
	});



	$('.showMessageBtn').click(function(){
		$(this).closest('td').find('.helpMessage').fadeToggle();
		return false;
	});







	$('.adsense-file-drop-area').on('dragenter', function (e) {
		e.stopPropagation();
		e.preventDefault();
		$(this).addClass('drag-enter');
	}).on('dragleave', function (e) {
		e.stopPropagation();
		e.preventDefault();
		$(this).removeClass('drag-enter');
	}).on('dragover', function (e) {
		e.stopPropagation();
		e.preventDefault();
	}).on('drop', function(e) {
		if (e.originalEvent.dataTransfer.files.length > 0) {
			upload_adsense_file(e.originalEvent.dataTransfer.files[0]);
		}
		$(this).removeClass('drag-enter');
	});


	$(document).on('dragenter', function (e){
		e.stopPropagation();
		e.preventDefault();
	}).on('dragover', function (e){
		e.stopPropagation();
		e.preventDefault();
	}).on('drop', function (e){
		e.stopPropagation();
		e.preventDefault();
	});


	$('.adsense-file-drop-area [name="adsense_file"]').on('change', function() {
		if (this.files.length > 0) {
		upload_adsense_file(this.files[0]);
		}
	});

	$('.adsense-file-drop-area .uploadAdsenseFileBtn').on('click', function() {
		$('.adsense-file-drop-area [name="adsense_file"]').click();
	});

	function upload_adsense_file(file)
	{
		var fd = new FormData();
		fd.append( "action", _ad_rpm_booster['slug'] );
		fd.append( "cmd", 'upload_adsense_file' );
		fd.append( "adsense_file", file );

		console.log('uploadAdsenseFileBtn');


		$.ajax({
			type: "POST",
			url: _ad_rpm_booster['ajax_url'],
			dataType: 'json',
			data: fd,
			processData : false,
			contentType : false,
			success: function(res) {
				console.log(res);

				if (res.rtc == 'ok')
				{
					getPageViewList();
					alert('アップロードしました。');
				}
				else
				{
					alert(res.msg);
				}
	        },
			error: function(res) {
	        }
	    });

		return false;
	}







	function rgb2hex(rgb) {
	    if (/^#[0-9A-F]{6}$/i.test(rgb)) return rgb;

	    rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
	    function hex(x) {
	        return ("0" + parseInt(x).toString(16)).slice(-2);
	    }
	    return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]);
	}




	function getPageViewList()
	{
		var ajax_data = {
			action: _ad_rpm_booster['slug'],
			cmd: 'get_page_view_list',

			d:0
		};

		$.ajax({
			type: "POST",
			url: _ad_rpm_booster['ajax_url'],
			dataType: 'json',
			data: ajax_data,
			success: function(res) {
				console.log(res);

				var template = tmpl("template-page-view-list");
				var result = template(res.data_list);

				$('.ad_rpm_booster_page_view_list .dataItems').html(result);
	        },
			error: function(res) {
	        }
	    });
	}
	getPageViewList();




})(window, jQuery);
