<?php
/**
 * Ad Rpm Booster Administrative Backend
 * @subpackage Admin
 * @package Ad_Rpm_Booster
 */

class Ad_Rpm_Booster_Admin {

	private $parent;

	/**
	 * Register hooks with WordPress API
	 * @param class $parent (reference) the Parent Class
	 */
	function __construct( &$parent ) {

		$this->parent = &$parent;

		add_action( 'admin_menu', array( &$this, 'options_menu_init' ) );


		add_action( 'admin_enqueue_scripts', array( &$this, 'style' ) );
	}

	/**
	 * Register our menu with WordPress
	 */
	function options_menu_init() {
		if ($this->parent->options->plugin_type < 1)
		{
			$page_title = $menu_title = 'infinite loading';
		}
		else
		{
			$page_title = $menu_title = 'Ad RPM Booster';
		}

		add_options_page(  $page_title, $menu_title, 'manage_options', 'ad_rpm_booster_options', array( &$this, 'options' ) );
	}


	/**
	 * Callback to load options template
	 */
	function options() {

//		$this->parent->b_setting_page = $this->parent->options->b_setting_page;
//		$this->parent->options->b_setting_page = 0;
//		wp_localize_script($this->parent->prefix . 'admin_js', 'b_setting_page', $this->parent->b_setting_page ? 1 : 0);


		//toggle presets page
		$file = isset( $_GET['manage-presets'] ) ? 'manage-presets' : 'options';
		$file = isset( $_GET['submit'] ) ? 'submit' : $file;

		require dirname( $this->parent->file ) . '/templates/' . $file . '.php';
	}


	function style(){
		global $wp_scripts;
		$ui = $wp_scripts->query('jquery-ui-core');

		wp_enqueue_style(
			'jquery-ui-smoothness',
			"//ajax.googleapis.com/ajax/libs/jqueryui/{$ui->ver}/themes/smoothness/jquery-ui.min.css",
			false,
			null
		);

		wp_enqueue_script( 'jquery-ui-tabs' );


		wp_enqueue_style( 'admin_style', plugins_url( '/css/admin-style.css', $this->parent->file ) );

		wp_enqueue_script( 'tmpl', plugins_url( '/js/tmpl.min.js', $this->parent->file ), array(), $this->parent->version, true );

		wp_enqueue_script( $this->parent->prefix . 'admin_js', plugins_url( '/js/admin-javascript.js', $this->parent->file ), array( 'jquery', 'jquery-ui-tabs' ), $this->parent->version, true );


//		wp_localize_script($this->parent->prefix . 'admin_js', 'slug', $this->parent->slug_);
//		wp_localize_script($this->parent->prefix . 'admin_js', 'ajax_url', $this->parent->ajax_url);

		$this->parent->b_setting_page = $this->parent->options->b_setting_page;
		$this->parent->options->b_setting_page = 0;

		wp_localize_script($this->parent->prefix . 'admin_js', '_ad_rpm_booster', array('slug' => $this->parent->slug_, 'ajax_url' => $this->parent->ajax_url, 'b_setting_page' => $this->parent->b_setting_page));

	}

}