<?php
/**
 * Template to display options page
 * @package ad_rpm_booster
 */
?>
<div class="wrap">
	<h2><?php if ($this->parent->options->plugin_type < 1) { ?>infinite loading<?php } else { ?>Ad RPM Booster<?php } ?></h2>








<div id="tabs">
  <ul>
	<?php if ($this->parent->options->plugin_type > 0) { ?><li><a href="#tabs-stats">統計情報</a></li><?php } ?>
	<li><a href="#tabs-setting">オプション設定</a></li>
	<li><a href="#tabs-faq">よくある質問</a></li>
  </ul>

<?php if ($this->parent->options->plugin_type > 0) { ?>
<div id="tabs-stats">
<h3>統計情報</h3>

<p>
ページ分割形式で分割表示した際に実際のページビューより多くカウントされてしまうため、補正したページビューからページCTRとRPMを計算します。<br>
AdSenseのレポートページから「Excel 用 CSV ファイルにエクスポート」形式でダウンロードしたデータファイルをアップロードしてください。<br>
データファイルには日付とクリック数、見積もり収益額を含めてください。<br>
※AdSenseヘルプに「カンマ区切り（CSV）形式」とありますが実際の内容はタブ区切りとなっています。そのままの内容でアップロードしてください。
</p>
<p>
※AdSenseヘルプ：<a href="https://support.google.com/adsense/answer/163213?hl=ja" target="_blank">レポートを CSV ファイルにエクスポートする</a>
</p>

<div class="adsense-file-drop-area">
<input type="file" name="adsense_file" class="display-none">
ここにファイルをドラッグ＆ドロップまたは<br>
<span><a class="button-primary uploadAdsenseFileBtn">ファイルを選択</a></span>
</div>



<table class="ad_rpm_booster_page_view_list">
<tr><th class="tableTitle">日付</td><th class="tableTitle">ページビュー</td><th class="tableTitle">クリック数</td><th class="tableTitle">見積もり収益額</td><th class="tableTitle">ページCTR</td><th class="tableTitle">ページRPM</td></tr>

<tbody class="dataItems"></tbody></table>
</div>
<?php } ?>


<div id="tabs-setting">
<h3>オプション設定</h3>
<div class="support-box">
<p>設定方法や利用方法に関してご不明点などございましたら、お気軽に<a href="https://www.ad-rpm-booster.com/support_desk" target="_blank">サポートデスク</a>までお問い合わせください。<br>
営業時間内（平日9時〜18時）であれば即日、遅くても翌営業日までに対応いたします。</p>
<p>お急ぎの場合は、下記番号までお電話ください。<br>
	TEL：<span class="tel">054-221-0211</span>　対応時間：9:00～18:00（土・日・祝日を除く）</p>
</div>
<form method="post" action="options.php" id="ad_rpm_booster_form">
<?php settings_fields( $this->parent->slug_ ); ?>
<input type="hidden" name="ad_rpm_booster[b_setting_page]" id="ad_rpm_booster[b_setting_page]" value="1" />


<table class="form-table">
	<tr valign="top" class="switch_plugin_type_2">
		<th scope="row">
			アクティベーション
		</th>
		<td>
			<?php if ($this->parent->is_activate) { ?>
			<span class="activate_enable">有効</span>
			<?php if ($this->parent->options->plugin_type > 1) { ?>（最大設置ブログ数：<?php if ($this->parent->options->max_reg_num < 0) { ?> 無制限
			<?php } else { echo $this->parent->options->max_reg_num; } ?>）
			<?php } ?>
			<?php } else { ?>
			<span class="activate_disable">無効</span>
			<?php if ($this->parent->options->plugin_type == 1) { ?>（トライアル版）
			<?php } ?>
			<?php } ?>
			<br />

			<span class="description">アクティベーションを行うことで全ての機能が使用可能になります。</span>

			<span><a class="showMessageBtn">[詳細を見る]</a></span>
			<div class="helpMessage display-none">購入時に入力いただいたメールアドレスにIDとライセンスコードをお送りしています。<br>
			『登録·変更』のチェックボックスにチェックを入れて、ID·ライセンスコードを入力してください。<br>
			お手持ちのライセンスがうまく反映されない場合は再度入力してください。<br>

			IDとライセンスコードがご不明な場合は、購入時のメールアドレスをご記入の上、<a href="https://www.ad-rpm-booster.com/support_desk" class="showHelpBtn" target="_blank">サポートデスク</a>までお問い合わせください。
			</div>

			<br /><label><input type="checkbox" class="chk_b_activate" id="ad_rpm_booster[b_activate]" name="ad_rpm_booster[b_activate]" value="true" <?php checked($this->parent->options->b_activate) ?> />登録・変更</label><br />
			<span class="description">アクティベーションの設定を更新する場合はチェックいれてください。</span>

			<input type="hidden" name="ad_rpm_booster[plugin_type]" id="ad_rpm_booster[plugin_type]" value="<?php echo esc_attr( $this->parent->options->plugin_type ); ?>" />
			<input type="hidden" name="ad_rpm_booster[setup_time]" id="ad_rpm_booster[setup_time]" value="<?php echo esc_attr( $this->parent->options->setup_time ); ?>" />
			<input type="hidden" name="ad_rpm_booster[activate_time]" id="ad_rpm_booster[activate_time]" value="<?php echo esc_attr( $this->parent->options->activate_time ); ?>" />
			<input type="hidden" name="ad_rpm_booster[activate_hash]" id="ad_rpm_booster[activate_hash]" value="<?php echo esc_attr( $this->parent->options->activate_hash ); ?>" />
			<input type="hidden" name="ad_rpm_booster[max_reg_num]" id="ad_rpm_booster[max_reg_num]" value="<?php echo esc_attr( $this->parent->options->max_reg_num ); ?>" />
			<input type="hidden" name="ad_rpm_booster[flg_all_option]" id="ad_rpm_booster[flg_all_option]" value="<?php echo esc_attr( $this->parent->options->flg_all_option ); ?>" />
		</td>
	</tr>

	<tr valign="top" class="switch_b_activate_true">
		<th scope="row">
			ID
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[activate_id]" id="ad_rpm_booster[activate_id]" value="<?php echo esc_attr( $this->parent->options->activate_id ); ?>" class="regular-text" /><br />
			<span class="description">IDを入力してください。</span>
		</td>
	</tr>
	<tr valign="top" class="switch_b_activate_true">
		<th scope="row">
			ライセンスコード
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[activate_pw]" id="ad_rpm_booster[activate_pw]" value="<?php echo esc_attr( $this->parent->options->activate_pw ); ?>" class="regular-text" /><br />
			<span class="description">ライセンスコードを入力してください。ライセンスコードは保存されません。</span>
		</td>
	</tr>
	<tr valign="top" class="switch_b_activate_true">
		<th scope="row">
		</th>
		<td>
			<p class="submit">
				<input type="submit" class="button-primary" value="保存" />
			</p>
		</td>
	</tr>



	<tr valign="top" class="switch_plugin_type_1">
		<th scope="row">
			分割表示
		</th>
		<td>
			<label><input type="radio" class="rdo_flg_view_ctrl" name="ad_rpm_booster[flg_view_ctrl]" id="ad_rpm_booster[flg_view_ctrl]" value="T" <?php checked($this->parent->options->flg_view_ctrl, 'T') ?> />あり</label>
			<label><input type="radio" class="rdo_flg_view_ctrl" name="ad_rpm_booster[flg_view_ctrl]" id="ad_rpm_booster[flg_view_ctrl]" value="F" <?php checked($this->parent->options->flg_view_ctrl, 'F') ?> />なし</label>
			<label><input type="radio" class="rdo_flg_view_ctrl" name="ad_rpm_booster[flg_view_ctrl]" id="ad_rpm_booster[flg_view_ctrl]" value="D" <?php checked($this->parent->options->flg_view_ctrl, 'D') ?> />自動</label>
			<br />
			<span class="description">『あり』にチェックを入れることで全ての記事が分割され、『続きを読む』ボタンの上部に広告が表示されます。<br>
最大の効果を出すためには、分割表示を「あり」にしてください。</span>

			<span><a class="showMessageBtn">[詳細を見る]</a></span>
			<div class="helpMessage display-none">
			「自動」は新着記事やページビューを元に（あり/なし）を記事ごとに自動で切り替えます。自動を選択した場合は、詳細設定より新着記事として扱う期間や基準となるアクセス数を調整可能です。<br>
			※表示形式で「部分非表示」を選択された場合にすべての機能が有効になります。「ページ分割」では、自動非表示機能はご利用いただけません。新着記事の設定のみ有効となります。<br>
			※選択するオプションによって設定できる項目が変わります。以下の設定できない項目は非表示になります。
			</div>
		</td>
	</tr>


	<tr valign="top" class="switch_plugin_type_2 switch_flg_view_ctrl_t">
		<th scope="row">
			表示形式
		</th>
		<td>
			<label><input type="radio" class="rdo_split_mode" name="ad_rpm_booster[split_mode]" id="ad_rpm_booster[split_mode]" value="A" <?php checked($this->parent->options->split_mode, 'A') ?> />部分非表示</label>
			<label><input type="radio" class="rdo_split_mode" name="ad_rpm_booster[split_mode]" id="ad_rpm_booster[split_mode]" value="B" <?php checked($this->parent->options->split_mode, 'B') ?> />ページ分割</label>
			<br />
			<span class="description">記事の分割方法を部分非表示にするか、ページ分割（ページネーション）にするかを選択できます。</span>

			<span><a class="showMessageBtn">[詳細を見る]</a></span>
			<div class="helpMessage display-none">
			効果に違いはありませんが、「ページ分割」はアドセンスでの見かけ上のRPMが低下します。統計情報タブに移動し、アドセンスのレポートをアップすることで補正したページRPMを確認いただけます。<br>
※ページ分割を選択した場合、rel=prev/nextタグが出力されますが、All in One SEOなど他のプラグインで出力している場合は、詳細設定で「出力する」のチェックを外してください。<br>
			※選択するオプションによって設定できる項目が変わります。以下の設定できない項目は非表示になります。
			</div>
		</td>
	</tr>


	<tr valign="top">
		<th scope="row">
			メインコンテンツ全体の領域 <span><a href="#help-contentSelector" class="showHelpBtn">[help]</a></span><br /><span class="description">（パンくずリスト、投稿記事、前後のページナビを含む。）</span>
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[contentSelector]" id="ad_rpm_booster[contentSelector]" value="<?php echo esc_attr( $this->parent->options->contentSelector ); ?>" class="regular-text" /><br /><span class="description">idまたはclassを入力してください（idの場合は「#」classの場合は「.」を前につけてください。）<a href="#help-dev-tool" class="showHelpBtn">※id・classの調べ方</a></span><br />
			<span><a href="https://www.ad-rpm-booster.com/support_desk" class="showHelpBtn" target="_blank">お分かりにならない場合はこちら</a></span>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row">
			記事全体の領域 <span><a href="#help-itemSelector" class="showHelpBtn">[help]</a></span><br>
<span class="description">（タイトル、アイキャッチ画像、投稿記事本文を含む。）</span>
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[itemSelector]" id="ad_rpm_booster[itemSelector]" value="<?php echo esc_attr( $this->parent->options->itemSelector ); ?>" class="regular-text" /><br /><span class="description">idまたはclassを入力してください（idの場合は「#」classの場合は「.」を前につけてください。<a href="#help-dev-tool" class="showHelpBtn">※id・classの調べ方</a></span><br />
			<span><a href="https://www.ad-rpm-booster.com/support_desk" class="showHelpBtn" target="_blank">お分かりにならない場合はこちら</a></span>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row">
			記事本文の領域 <span><a href="#help-itemBodySelector" class="showHelpBtn">[help]</a></span><br>
<span class="description">（記事本文以外は含まれないようにしてください。）</span>
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[itemBodySelector]" id="ad_rpm_booster[itemBodySelector]" value="<?php echo esc_attr( $this->parent->options->itemBodySelector ); ?>" class="regular-text" /><br /><span class="description">idまたはclassを入力してください（idの場合は「#」classの場合は「.」を前につけてください。）<a href="#help-dev-tool" class="showHelpBtn">※id・classの調べ方</a></span><br />
			<span><a href="https://www.ad-rpm-booster.com/support_desk" class="showHelpBtn" target="_blank">お分かりにならない場合はこちら</a></span>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row">
			本文下のリンクの領域 <span><a href="#help-navSelector" class="showHelpBtn">[help]</a></span><br />
			<span class="description">（前後記事へのリンクや関連記事のリンク。）</span>
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[navSelector]" id="ad_rpm_booster[navSelector]" value="<?php echo esc_attr( $this->parent->options->navSelector ); ?>" class="regular-text" /><br /><span class="description">idまたはclassを入力してください（idの場合は「#」classの場合は「.」を前につけてください。）<a href="#help-dev-tool" class="showHelpBtn">※id・classの調べ方</a></span><br />
			<span><a href="https://www.ad-rpm-booster.com/support_desk" class="showHelpBtn" target="_blank">お分かりにならない場合はこちら</a></span>
		</td>
	</tr>

	<tr valign="top" class="switch_flg_view_ctrl_t switch_split_mode_b">
		<th scope="row">
			分割ページ最後のみで表示する領域<br />
			<span class="description">（SNSボタンやコメント等。）</span>
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[displayOnlyLastPageSelector]" id="ad_rpm_booster[displayOnlyLastPageSelector]" value="<?php echo esc_attr( $this->parent->options->displayOnlyLastPageSelector ); ?>" class="regular-text"	/><br />
			<span class="description">「ページ分割」時、最後のページ以外では非表示になります。</span>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row">
			サイドバーの領域 <span><a href="#help-navSelector3" class="showHelpBtn">[help]</a></span><br>
<span class="description">（スマホ時にページ下部に表示されるサイドバー。）</span>
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[sidebarSelector]" id="ad_rpm_booster[sidebarSelector]" value="<?php echo esc_attr( $this->parent->options->sidebarSelector ); ?>" class="regular-text"	/><br /><span class="description">idまたはclassを入力してください（idの場合は「#」classの場合は「.」を前につけてください。）<a href="#help-dev-tool" class="showHelpBtn">※id・classの調べ方</a></span><br />
			<span><a href="https://www.ad-rpm-booster.com/support_desk" class="showHelpBtn" target="_blank">お分かりにならない場合はこちら</a></span>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row">
			広告コード
		</th>
		<td>
			<textarea name="ad_rpm_booster[adCode]" id="ad_rpm_booster[adCode]" class="regular-text"><?php echo esc_attr( $this->parent->options->adCode ); ?></textarea><br />
			<span class="description">広告のHTMLコード(GoogleadSenseなどの貼り付け用コード)を入力してください。<br />広告の種類はGoogleAdSenseのネイティブ広告『記事内広告』を推奨しています。</span>
		</td>
	</tr>


</table>




<div><label><input type="checkbox" class="chk_show_setting_detail_block" style="display:none;" /><span class="button-secondary">詳細設定</span></label></div>


<div class="SettingDetailBlock">
<table class="form-table">
	<tr valign="top">
		<th scope="row">
			無限スクロールの使用
		</th>
		<td>
			<label><input type="checkbox" id="ad_rpm_booster[flg_infinite_scroll]" name="ad_rpm_booster[flg_infinite_scroll]" value="true" <?php checked($this->parent->options->flg_infinite_scroll) ?> />使用する</lable><br />
			<span class="description">無限スクロールのオン・オフを切り替えることができます。</span>

			<span><a class="showMessageBtn">[詳細を見る]</a></span>
			<div class="helpMessage display-none">
			チェックを外すと無限スクロール機能がオフになり、通常の表示に戻ります。<br>
			※記事のカテゴリーやタグが未設定の場合、正しく動作しません。必ず記事ごとにカテゴリーやタグを設定してください。
			</div>
		</td>
	</tr>

	<tr valign="top" class="switch_flg_view_ctrl_d">
		<th scope="row">
			新着記事期間
		</th>
		<td>
			<label><input type="radio" name="ad_rpm_booster[new_days]" id="ad_rpm_booster[new_days]" value="30" <?php checked($this->parent->options->new_days, '30') ?> />１ヶ月</label>
			<label><input type="radio" name="ad_rpm_booster[new_days]" id="ad_rpm_booster[new_days]" value="60" <?php checked($this->parent->options->new_days, '60') ?> />２ヶ月</label>
			<label><input type="radio" name="ad_rpm_booster[new_days]" id="ad_rpm_booster[new_days]" value="90" <?php checked($this->parent->options->new_days, '90') ?> />３ヶ月</label>
			<br />
			<span class="description">分割表示で「自動」を選択した場合の新着記事として扱う期間を設定します。</span>

			<span><a class="showMessageBtn">[詳細を見る]</a></span>
			<div class="helpMessage display-none">
			ここで設定した期間を経過するまでの間、記事が分割されず、記事全文が表示された状態となります。<br>
			ただし、「表示切り替え変動閾値」で設定した値よりもアクセスが増加した場合にはここで設定した期間内でも分割が適用されます。
			</div>
		</td>
	</tr>



	<tr valign="top" class="switch_flg_view_ctrl_d switch_split_mode_a">
		<th scope="row">
			表示切り替え変動閾値（開始時）
		</th>
		<td>
			<label><input type="radio" name="ad_rpm_booster[judge_long_threshold]" id="ad_rpm_booster[judge_long_threshold]" value="A" <?php checked($this->parent->options->judge_long_threshold, 'A') ?> />低</label>
			<label><input type="radio" name="ad_rpm_booster[judge_long_threshold]" id="ad_rpm_booster[judge_long_threshold]" value="B" <?php checked($this->parent->options->judge_long_threshold, 'B') ?> />中</label>
			<label><input type="radio" name="ad_rpm_booster[judge_long_threshold]" id="ad_rpm_booster[judge_long_threshold]" value="C" <?php checked($this->parent->options->judge_long_threshold, 'C') ?> />高</label>
			<label><input type="radio" name="ad_rpm_booster[judge_long_threshold]" id="ad_rpm_booster[judge_long_threshold]" value="D" <?php checked($this->parent->options->judge_long_threshold, 'D') ?> />カスタム <input type="text" name="ad_rpm_booster[judge_long_threshold_value]" id="ad_rpm_booster[judge_long_threshold_value]" value="<?php echo esc_attr( $this->parent->options->judge_long_threshold_value ); ?>" class="small-text" />%</label>
			<br />
			<span class="description">プラグインインストール時のページビューを比較して、閾値より減った場合は分割なしになります。</span>

			<span><a class="showMessageBtn">[詳細を見る]</a></span>
			<div class="helpMessage display-none">
			サイトのアクセス変動が大きく、切り替えが頻繁に発生する場合は、「高」にすることで分割表示を維持できます。<br>
			※「新着記事期間」の設定よりも優先されます。<br>
			※こちらの設定は、表示形式で「部分非表示」を選択された場合にのみ有効になります。
			</div>
		</td>
	</tr>


	<tr valign="top" class="switch_flg_view_ctrl_d switch_split_mode_a">
		<th scope="row">
			表示切り替え変動閾値（１週間）
		</th>
		<td>
			<label><input type="radio" name="ad_rpm_booster[judge_threshold]" id="ad_rpm_booster[judge_threshold]" value="A" <?php checked($this->parent->options->judge_threshold, 'A') ?> />低</label>
			<label><input type="radio" name="ad_rpm_booster[judge_threshold]" id="ad_rpm_booster[judge_threshold]" value="B" <?php checked($this->parent->options->judge_threshold, 'B') ?> />中</label>
			<label><input type="radio" name="ad_rpm_booster[judge_threshold]" id="ad_rpm_booster[judge_threshold]" value="C" <?php checked($this->parent->options->judge_threshold, 'C') ?> />高</label>
			<label><input type="radio" name="ad_rpm_booster[judge_threshold]" id="ad_rpm_booster[judge_threshold]" value="D" <?php checked($this->parent->options->judge_threshold, 'D') ?> />カスタム <input type="text" name="ad_rpm_booster[judge_threshold_value]" id="ad_rpm_booster[judge_threshold_value]" value="<?php echo esc_attr( $this->parent->options->judge_threshold_value ); ?>" class="small-text" />%</label>
			<br />
			<span class="description">１週間のページビューを比較して、閾値より増えた場合分割ありに、減った場合は分割なしになります。</span>

			<span><a class="showMessageBtn">[詳細を見る]</a></span>
			<div class="helpMessage display-none">
			サイトのアクセス変動に応じて選択してください。「高」にすることで切り替え頻度は少なくなくなります。<br>
			※「新着記事期間」の設定よりも優先されます。<br>
			※こちらの設定は、表示形式で「部分非表示」を選択された場合にのみ有効になります。
			</div>
		</td>
	</tr>


	<tr valign="top" class="switch_flg_view_ctrl_d switch_split_mode_a">
		<th scope="row">
			表示切り替え変動閾値（前日）
		</th>
		<td>
			<label><input type="radio" name="ad_rpm_booster[judge_short_threshold]" id="ad_rpm_booster[judge_short_threshold]" value="A" <?php checked($this->parent->options->judge_short_threshold, 'A') ?> />低</label>
			<label><input type="radio" name="ad_rpm_booster[judge_short_threshold]" id="ad_rpm_booster[judge_short_threshold]" value="B" <?php checked($this->parent->options->judge_short_threshold, 'B') ?> />中</label>
			<label><input type="radio" name="ad_rpm_booster[judge_short_threshold]" id="ad_rpm_booster[judge_short_threshold]" value="C" <?php checked($this->parent->options->judge_short_threshold, 'C') ?> />高</label>
			<label><input type="radio" name="ad_rpm_booster[judge_short_threshold]" id="ad_rpm_booster[judge_short_threshold]" value="D" <?php checked($this->parent->options->judge_short_threshold, 'D') ?> />カスタム <input type="text" name="ad_rpm_booster[judge_short_threshold_value]" id="ad_rpm_booster[judge_short_threshold_value]" value="<?php echo esc_attr( $this->parent->options->judge_short_threshold_value ); ?>" class="small-text" />%</label>
			<br />
			<span class="description">前日の同時間帯と比較して、ページビューが閾値より増えた場合分割ありになります。</span>

			<span><a class="showMessageBtn">[詳細を見る]</a></span>
			<div class="helpMessage display-none">
			サイトのアクセス変動に応じて選択してください。「高」にすることで切り替え頻度は少なくなくなります。<br>
			※「新着記事期間」の設定よりも優先されます。<br>
			※こちらの設定は、表示形式で「部分非表示」を選択された場合にのみ有効になります。
			</div>
		</td>
	</tr>

	<tr valign="top" class="switch_flg_view_ctrl_t">
		<th scope="row">
			追加の広告表示
		</th>
		<td>
			<label><input type="checkbox" id="ad_rpm_booster[flgAdInsertContentsLast]" name="ad_rpm_booster[flgAdInsertContentsLast]" value="true" <?php checked($this->parent->options->flgAdInsertContentsLast) ?> />分割ボタンの下にも広告を表示する</lable><br />
			<span class="description">チェックを入れることで、「記事の続きを読む」ボタンの上部だけでなく、下部にも広告が表示されるようになります。<br />これによって、クリック率の上昇が期待できます。</span>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row">
			広告につけるラベルの文言
		</th>
		<td>
			<label><input type="radio" name="ad_rpm_booster[ad_text_str]" id="ad_rpm_booster[ad_text_str]" value="" <?php checked($this->parent->options->ad_text_str, '') ?> />（表示なし）</label>
			<label><input type="radio" name="ad_rpm_booster[ad_text_str]" id="ad_rpm_booster[ad_text_str]" value="スポンサーリンク" <?php checked($this->parent->options->ad_text_str, 'スポンサーリンク') ?> />スポンサーリンク</label>
			<label><input type="radio" name="ad_rpm_booster[ad_text_str]" id="ad_rpm_booster[ad_text_str]" value="広告" <?php checked($this->parent->options->ad_text_str, '広告') ?> />広告</label>
			<br />
			<span class="description">広告の上部に表示するラベルの文言を設定します。必須ではありませんが、ユーザーがコンテンツと広告を明確に区別できるよう「スポンサーリンク」「広告」のラベルを表示することを推奨します。</span>
		</td>
	</tr>

	<tr valign="top" class="switch_flg_view_ctrl_t">
		<th scope="row">
			記事分割の基準となる見出しタグ
		</th>
		<td>
			<label><input type="radio" name="ad_rpm_booster[split_tag]" id="ad_rpm_booster[split_tag]" value="h2" <?php checked($this->parent->options->split_tag, 'h2') ?> />H2</label>
			<label><input type="radio" name="ad_rpm_booster[split_tag]" id="ad_rpm_booster[split_tag]" value="h3" <?php checked($this->parent->options->split_tag, 'h3') ?> />H3</label>
			<br />
			<span class="description">いずれか選択した見出しタグの直前で記事が分割されます。<br />通常は、「H2」を推奨しますが、記事の構成などに合わせて最適なタグをお選びください。</span>
		</td>
	</tr>

	<tr valign="top" class="switch_flg_view_ctrl_t">
		<th scope="row">
			最初に分割する文字数
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[split_first_length]" id="ad_rpm_booster[split_first_length]" value="<?php echo esc_attr( $this->parent->options->split_first_length ); ?>" class="regular-text"	/><br />
			<span class="description">記事にアクセスしてきたユーザーに対して最初に表示される最低文字数を設定します。<br />ここで設定した文字数以降に出てくる見出しタグの直前で記事が分割され、「続きを読む」ボタンが表示されます。
			</span>
		</td>
	</tr>

	<tr valign="top" class="switch_flg_view_ctrl_t">
		<th scope="row">
			２分割目以降に分割する文字数
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[split_second_length]" id="ad_rpm_booster[split_second_length]" value="<?php echo esc_attr( $this->parent->options->split_second_length ); ?>" class="regular-text"	/><br />
			<span class="description">「続きを読む」をクリックした後に表示される領域の最低文字数を設定します。ここで設定した文字数以降に出てくる見出しタグの直前で記事が分割され、「続きを読む」ボタンが表示されます。
			</span>
		</td>
	</tr>




	<tr valign="top" class="switch_flg_view_ctrl_t">
		<th scope="row">
			記事分割時の「記事の続きを読む」ボタンの文言
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[readmore_text_str]" id="ad_rpm_booster[readmore_text_str]" value="<?php echo esc_attr( $this->parent->options->readmore_text_str ); ?>" class="regular-text"	/><br />
			<span class="description">「記事の続きを読む」ボタンに表示される文言を自由に設定できます。<br />デフォルトでは、「記事の続きを読む」となっています。</span>
		</td>
	</tr>

	<tr valign="top" class="display-none">
		<th scope="row">
			「記事の続きを読む」ボタンの文字色
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[readmore_text_color]" id="ad_rpm_booster[readmore_text_color]" value="<?php echo esc_attr( $this->parent->options->readmore_text_color ); ?>" class="regular-text"	/><br />
			<span class="description">「記事の続きを読む」ボタンの文字色を入力してください。</span>
		</td>
	</tr>

	<tr valign="top" class="display-none">
		<th scope="row">
			「記事の続きを読む」ボタンの背景色
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[readmore_text_backgroud_color]" id="ad_rpm_booster[readmore_text_backgroud_color]" value="<?php echo esc_attr( $this->parent->options->readmore_text_backgroud_color ); ?>" class="regular-text"	/><br />
			<span class="description">「記事の続きを読む」ボタンの背景色を入力してください。</span>
		</td>
	</tr>

	<tr valign="top" class="switch_flg_view_ctrl_t">
		<th scope="row">
			「記事の続きを読む」ボタンのスタイル
		</th>
		<td>
			<div class="adminReadmoreBox">
				<label><input type="radio" name="ad_rpm_booster[readmore_text_style_set]" id="ad_rpm_booster[readmore_text_style_set]" value="A" <?php checked($this->parent->options->readmore_text_style_set, 'A') ?> /><span class="readmoreBtn style1">記事の続きを読む</span></label>
				<label><input type="radio" name="ad_rpm_booster[readmore_text_style_set]" id="ad_rpm_booster[readmore_text_style_set]" value="B" <?php checked($this->parent->options->readmore_text_style_set, 'B') ?> /><span class="readmoreBtn style2">記事の続きを読む</span></label>
				<label><input type="radio" name="ad_rpm_booster[readmore_text_style_set]" id="ad_rpm_booster[readmore_text_style_set]" value="C" <?php checked($this->parent->options->readmore_text_style_set, 'C') ?> /><span class="readmoreBtn style3">記事の続きを読む</span></label>
			</div>
			<span class="description">「記事の続きを読む」ボタンのスタイルを設定します。背景色が薄いほど、広告のクリック率が高くなる傾向にあります。<br>
			※クリック数（CTR）が急激に減少し、２クリック制の適用が疑われる場合は、赤色の背景を選択してください。
			</span>
		</td>
	</tr>


	<tr valign="top">
		<th scope="row">
			「下に続きます」の文言
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[scroll_text_str]" id="ad_rpm_booster[scroll_text_str]" value="<?php echo esc_attr( $this->parent->options->scroll_text_str ); ?>" class="regular-text"	/><br />
			<span class="description">記事に続きがあることを示す文言を広告上部に表示します。<br />デフォルトでは「記事はPRの下に続きます・・・」となっていますが、お使いのブログに合わせて自由に設定可能です。</span>
		</td>
	</tr>

	<tr valign="top" class="display-none">
		<th scope="row">
			「下に続きます」の背景色
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[scroll_text_backgroud_color]" id="ad_rpm_booster[scroll_text_backgroud_color]" value="<?php echo esc_attr( $this->parent->options->scroll_text_backgroud_color ); ?>" class="regular-text"	/><br />
			<span class="description">広告上に表示する「下に続きます」の背景色を入力してください。</span>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row">
			「下に続きます」テキストのスタイル
		</th>
		<td>
			<div class="adminScrollTextBox">
				<label><input type="radio" name="ad_rpm_booster[scroll_text_style_set]" id="ad_rpm_booster[scroll_text_style_set]" value="A" <?php checked($this->parent->options->scroll_text_style_set, 'A') ?> /><div class="scrollTextBox scrollUnit01">《<span class="style1">記事はPRの下に続きます・・・</span>》</div></label>
				<label><input type="radio" name="ad_rpm_booster[scroll_text_style_set]" id="ad_rpm_booster[scroll_text_style_set]" value="B" <?php checked($this->parent->options->scroll_text_style_set, 'B') ?> /><div class="scrollTextBox scrollUnit01">《<span class="style2">記事はPRの下に続きます・・・</span>》</div></label>
				<label><input type="radio" name="ad_rpm_booster[scroll_text_style_set]" id="ad_rpm_booster[scroll_text_style_set]" value="C" <?php checked($this->parent->options->scroll_text_style_set, 'C') ?> /><div class="scrollTextBox scrollUnit01">《<span class="style3">記事はPRの下に続きます・・・</span>》</div></label>
			</div>
			<br style="clear: both;">
			<span class="description">上記の『「下に続きます」の文言』で設定したテキストのスタイルを設定します。<br />お使いのブログのデザインに合わせて選択してください。</span>
		</td>
	</tr>





	<tr valign="top">
		<th scope="row">
			記事一覧（無限スクロール）での「続きを読む」ボタンの文言
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[more_text_str]" id="ad_rpm_booster[more_text_str]" value="<?php echo esc_attr( $this->parent->options->more_text_str ); ?>" class="regular-text"	/><br />
			<span class="description">無限スクロールで読み込まれる記事一覧での「続きを読む」ボタンの文言を設定できます。<br />デフォルトでは「続きを読む」となっています。</span>
		</td>
	</tr>


	<tr valign="top" class="display-none">
		<th scope="row">
			関連記事マークの文字色
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[related_text_color]" id="ad_rpm_booster[related_text_color]" value="<?php echo esc_attr( $this->parent->options->related_text_color ); ?>" class="regular-text"	/><br />
			<span class="description">関連記事マークの文字色を入力してください。</span>
		</td>
	</tr>

	<tr valign="top" class="display-none">
		<th scope="row">
			関連記事マークの背景色
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[related_text_backgroud_color]" id="ad_rpm_booster[related_text_backgroud_color]" value="<?php echo esc_attr( $this->parent->options->related_text_backgroud_color ); ?>" class="regular-text"	/><br />
			<span class="description">関連記事マークの背景色を入力してください。</span>
		</td>
	</tr>

	<tr valign="top" class="display-none">
		<th scope="row">
			関連記事リンクの文字色
		</th>
		<td>
			<input type="text" name="ad_rpm_booster[related_link_text_color]" id="ad_rpm_booster[related_link_text_color]" value="<?php echo esc_attr( $this->parent->options->related_link_text_color ); ?>" class="regular-text"	/><br />
			<span class="description">関連記事リンクの文字色を入力してください。</span>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row">
			関連記事のスタイル
		</th>
		<td>
			<div class="adminRelatedLinkBox">
				<label><input type="radio" name="ad_rpm_booster[related_text_style_set]" id="ad_rpm_booster[related_text_style_set]" value="A" <?php checked($this->parent->options->related_text_style_set, 'A') ?> /><div class="related-link-item style1"><span>関連記事</span><a>会社の大掃除は段取りが大切！？ スムーズに行う方法を解説します。 </a></div></label>
				<label><input type="radio" name="ad_rpm_booster[related_text_style_set]" id="ad_rpm_booster[related_text_style_set]" value="B" <?php checked($this->parent->options->related_text_style_set, 'B') ?> /><div class="related-link-item style2"><span>関連記事</span><a>会社の大掃除は段取りが大切！？ スムーズに行う方法を解説します。 </a></div></label>
				<label><input type="radio" name="ad_rpm_booster[related_text_style_set]" id="ad_rpm_booster[related_text_style_set]" value="C" <?php checked($this->parent->options->related_text_style_set, 'C') ?> /><div class="related-link-item style3"><span>関連記事</span><a>会社の大掃除は段取りが大切！？ スムーズに行う方法を解説します。 </a></div></label>
			</div>
			<br style="clear: both;">
			<span class="description">見出しタグの上部に表示される関連記事の表示スタイルを選択できます。<br />お使いのブログのデザインに合わせて選択してください。<br>
			※記事のカテゴリーやタグが未設定の場合、正しく動作しません。必ず記事ごとにカテゴリーやタグを設定してください。</span>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row">
			関連記事表示数
		</th>
		<td>
			<label><input type="radio" name="ad_rpm_booster[related_link_num]" id="ad_rpm_booster[related_link_num]" value="0" <?php checked($this->parent->options->related_link_num, '0') ?> />0</label>
			<label><input type="radio" name="ad_rpm_booster[related_link_num]" id="ad_rpm_booster[related_link_num]" value="1" <?php checked($this->parent->options->related_link_num, '1') ?> />1</label>
			<label><input type="radio" name="ad_rpm_booster[related_link_num]" id="ad_rpm_booster[related_link_num]" value="2" <?php checked($this->parent->options->related_link_num, '2') ?> />2</label>
			<label><input type="radio" name="ad_rpm_booster[related_link_num]" id="ad_rpm_booster[related_link_num]" value="3" <?php checked($this->parent->options->related_link_num, '3') ?> />3</label>
			<label><input type="radio" name="ad_rpm_booster[related_link_num]" id="ad_rpm_booster[related_link_num]" value="4" <?php checked($this->parent->options->related_link_num, '4') ?> />4</label>
			<label><input type="radio" name="ad_rpm_booster[related_link_num]" id="ad_rpm_booster[related_link_num]" value="5" <?php checked($this->parent->options->related_link_num, '5') ?> />5</label>
			<br />
			<span class="description">上記の『関連記事のスタイル』で設定した関連記事の表示数を0〜5の間で設定します。<br />デフォルトでは2が選択されています。</span>
		</td>
	</tr>








	<tr valign="top" class="switch_flg_view_ctrl_t switch_split_mode_a">
		<th scope="row">
			分割数制限
		</th>
		<td>
			<label><input type="radio" name="ad_rpm_booster[max_split_num]" id="ad_rpm_booster[max_split_num]" value="1" <?php checked($this->parent->options->max_split_num, '1') ?> />１回のみ</label>
			<label><input type="radio" name="ad_rpm_booster[max_split_num]" id="ad_rpm_booster[max_split_num]" value="-1" <?php checked($this->parent->options->max_split_num, '-1') ?> />無制限</label>
			<br />
			<span class="description">記事を分割する最大数を設定します。</span>

			<span><a class="showMessageBtn">[詳細を見る]</a></span>
			<div class="helpMessage display-none">表示形式で「部分非表示」を選択された場合、分割を最初の１回のみにするか、無制限に分割するかを選択できます。
			</div>
		</td>
	</tr>




	<tr valign="top" class="switch_flg_view_ctrl_t switch_split_mode_b">
		<th scope="row">
			rel=prev/nextタグの出力
		</th>
		<td>
			<label><input type="checkbox" id="ad_rpm_booster[b_output_rel_prev_next]" name="ad_rpm_booster[b_output_rel_prev_next]" value="true" <?php checked($this->parent->options->b_output_rel_prev_next) ?> />出力する</lable><br />
			<span class="description">表示形式で「ページ分割」を選択した場合は、こちらにチェックを入れてください。<br>
			ただし、All in One SEOなど他のプラグインやテーマで出力している場合はチェックを外してください。
			</span>
		</td>
	</tr>


	<tr valign="top">
		<th scope="row">
			サイドバーの表示制御
		</th>
		<td>
			<label><input type="checkbox" id="ad_rpm_booster[flg_ctrl_sidebar]" name="ad_rpm_booster[flg_ctrl_sidebar]" value="true" <?php checked($this->parent->options->flg_ctrl_sidebar) ?> />制御する</lable><br />
			<span class="description">スマホでサイトを閲覧した際のサイドバーの表示を制御します。</span>

			<span><a class="showMessageBtn">[詳細を見る]</a></span>
			<div class="helpMessage display-none">
			サイドバーがページ下部に自動で移動する仕様の場合、無限スクロールで記事が次々と読み込まれるため、サイドバーの内容を見ることができません。「制御する」にチェックを入れることで、スマホ閲覧時にはページ下部にサイドバーの開閉ボタンが追加され、クリックすることでサイドバーの内容を表示できるようになります。
			</div>
		</td>
	</tr>






</table>
</div>

<p class="submit">
	<input type="submit" class="button-primary" value="保存" />
</p>

</form>
</div>



<div id="tabs-faq">
<h3>よくある質問</h3>
<div class="support-box">
<p>設定方法や利用方法に関してご不明点などございましたら、お気軽に<a href="https://www.ad-rpm-booster.com/support_desk" target="_blank">サポートデスク</a>までお問い合わせください。<br>
営業時間内（平日9時〜18時）であれば即日、遅くても翌営業日までに対応いたします。</p>
<p>お急ぎの場合は、下記番号までお電話ください。<br>
TEL：<span class="tel">054-221-0211</span>　対応時間：9:00～18:00（土・日・祝日を除く）</p>
</div>


<div class="boxQA">
<h4>見出しタグを使っていないブログでは分割表示ができないのでしょうか？</h4>
<p>見出しタグを分割の基準としているため、見出しタグが設定されていないブログでは分割表示をお使いいただけません。必ず記事の中に見出しタグを設定してください。見出しを適切に設定することで、ユーザーが記事の内容を理解しやすくなり、Googleからの評価も高まります。</p>
</div>

<div class="boxQA">
<h4>2クリック制が適用されてしまったようなのですが、解除するにはどうすればよいでしょうか？</h4>
<p>クリック率が急激に高くなり過ぎた場合、誤クリックが増えたとGoogleが誤判定し、2クリック制が適用されることがあります。「記事の続きを読む」ボタンのスタイルで赤色の背景を選択することで、クリック率の上昇がわずかに抑えられ、通常、2〜3日ほどで2クリック制が解除されます。</p>
</div>

<div class="boxQA">
<h4>無限スクロールの使用で「使用する」にチェックを入れても無限スクロールで記事が読み込まれないのですが・・・。</h4>
<p>無限スクロールはカテゴリーやタグが同じ記事を次々に読み込む仕組みです。カテゴリーやタグが同じ記事がない場合には無限スクロールは動作しません。</p>
</div>

<div class="boxQA">
<h4>関連記事リンクが表示されないのですが・・・。</h4>
<p>関連記事リンク生成機能はカテゴリーやタグが同じ記事へのリンクが自動的に設置される仕組みです。カテゴリーやタグが同じ記事がない場合には表示されません。</p>
</div>


<div class="boxQA">
<h4>設定するidやclassが分からないのですが、、</h4>
<p>テーマによって設定内容が異なります。以下の代表的なテーマの設定内容を参考にしてください。<br>
<span>こちらに掲載されていないテーマをお使いの場合は、サポートデスクまで<a href="https://www.ad-rpm-booster.com/support_desk" class="showHelpBtn" target="_blank">お問い合わせ</a>いただければお調べして回答いたします。営業時間内であれば即日、遅くても翌営業日までに対応いたします。</span>
</p>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Twenty Nineteen</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns-group</td></tr>
<tr><td>サイドバーの領域</td><td>.widget-area</td></tr>
</table>


<table cellpadding="0" cellspacing="0">
<caption>テーマ：Twenty Seventeen</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns-group</td></tr>
<tr><td>サイドバーの領域</td><td>#secondary</td></tr>
</table>


<table cellpadding="0" cellspacing="0">
<caption>テーマ：Simplicity1.9.3</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns-group</td></tr>
<tr><td>サイドバーの領域</td><td>#sidebar</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Simplicity2（シンプリシティ2）</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns-group</td></tr>
<tr><td>サイドバーの領域</td><td>#sidebar</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Base WP</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns-group</td></tr>
<tr><td>サイドバーの領域</td><td>#secondary</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Sentry</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>.content</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns-group</td></tr>
<tr><td>サイドバーの領域</td><td>#sidebar</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Luxeritas（ルクセリタス）</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#core</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>&gt;.clearfix</td></tr>
<tr><td>本文下のリンクの領域</td><td>#pnavi,#related-box</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.snsb</td></tr>
<tr><td>サイドバーの領域</td><td>#sidebar</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Cocoon（コクーン）</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>#pager-post-navi</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns-group</td></tr>
<tr><td>サイドバーの領域</td><td>#sidebar</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Godios（ゴディオス）</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#entry</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>#entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns-group</td></tr>
<tr><td>サイドバーの領域</td><td>#side</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Xeory Base（セオリーベース）</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.post-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.bzb-sns-btn</td></tr>
<tr><td>サイドバーの領域</td><td>#side</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：LION BLOG</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>.l-main</td></tr>
<tr><td>記事全体の領域</td><td>article</td></tr>
<tr><td>記事本文の領域</td><td>.content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.prevNext</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.socialList</td></tr>
<tr><td>サイドバーの領域</td><td>.l-sidebar</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：beans</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>.tm-primary</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>div[itemprop=articleBody]</td></tr>
<tr><td>本文下のリンクの領域</td><td>.uk-pagination</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns-group</td></tr>
<tr><td>サイドバーの領域</td><td>.tm-secondary</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：stinger8</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>.st-main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.mainbox</td></tr>
<tr><td>本文下のリンクの領域</td><td>.p-navi</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns</td></tr>
<tr><td>サイドバーの領域</td><td>#side</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Gush5</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>article</td></tr>
<tr><td>記事本文の領域</td><td>.article-inner</td></tr>
<tr><td>本文下のリンクの領域</td><td>.page-pn</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.article-snsbox</td></tr>
<tr><td>サイドバーの領域</td><td>#sub</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：マテリアル</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>.main</td></tr>
<tr><td>記事全体の領域</td><td>.content-box</td></tr>
<tr><td>記事本文の領域</td><td>.content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.min-box</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.share-buttons</td></tr>
<tr><td>サイドバーの領域</td><td>.side</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Lightning</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-body</td></tr>
<tr><td>本文下のリンクの領域</td><td>.pager</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.veu_socialSet</td></tr>
<tr><td>サイドバーの領域</td><td>.sideSection</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：WING（AFFINGER5）</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#contentInner</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.mainbox</td></tr>
<tr><td>本文下のリンクの領域</td><td>.p-navi</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns</td></tr>
<tr><td>サイドバーの領域</td><td>#side</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：STORK（ストーク）</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns</td></tr>
<tr><td>サイドバーの領域</td><td>#sidebar1</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Hummingbird（ハミングバード）</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns</td></tr>
<tr><td>サイドバーの領域</td><td>#sidebar1</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：ALBATROS（アルバトロス）</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.entry-content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns</td></tr>
<tr><td>サイドバーの領域</td><td>#sidebar1</td></tr>
</table>

<table cellpadding="0" cellspacing="0">
<caption>テーマ：Diver</caption>
<tr><th>要素</th><th>内容</th></tr>
<tr><td>メインコンテンツ全体の領域</td><td>#single-main</td></tr>
<tr><td>記事全体の領域</td><td>.post</td></tr>
<tr><td>記事本文の領域</td><td>.content</td></tr>
<tr><td>本文下のリンクの領域</td><td>.navigation</td></tr>
<tr><td>分割ページ最後のみで表示する領域</td><td>.sns</td></tr>
<tr><td>サイドバーの領域</td><td>#sidebar</td></tr>
</table>


</div>




</div>



</div>







<div id="help-dev-tool" class="display-none">
<h3>デベロッパーツールの説明</h3>
<p>idやclassの確認は、「デベロッパーツール」を使うと便利です。<br>
その中でも「Google Chrome」なら簡単にできます。※他のブラウザ(firefox等)でも同様のツールがあります。</p>

<video src="https://www.ad-rpm-booster.com/man/devtools.mov" controls></video>

<h4 class="titleDeco01">【1】デベロッパーツールを表示させる</h4>
<img src="<?php echo $this->parent->plugins_url; ?>/images/help-dev-tool01.png" class="photoRight">
<p>調べたいページを表示させて、以下のショートカットキーで起動します。<br>
Windowsの場合：キーボードの「F12」を押します。<br>
Macの場合：キーボードの「Command」＋「Option」＋「I」を押します。<br>
または右クリックして「検証」をクリックで起動します。<br>
画面の下（また右側）に別枠で「デベロッパーツール」が表示されます。</p>
<h4 class="titleDeco01">【2】調べたい箇所を選択する</h4>
<img src="<?php echo $this->parent->plugins_url; ?>/images/help-dev-tool02.png" class="photoRight">
<p>デベロッパーツールが開いたら左上にあるアイコンをマウスでクリックします。<br>
この状態でページ上の調べたい箇所にカーソルを合わせると、該当する部分のソースコードがハイライトされます。
さらにクリックするとソースコードが選択されますので、「id」「class」を調べることが可能です。逆に、ソースコードをクリックすることで調べたい箇所をハイライトすることもできます。</p>



<!--<img src="<?php echo $this->parent->plugins_url; ?>/images/help-dev-tool.png">

<p>
要素のidやclassの確認は、Chromeなら簡単にできます。※他のブラウザ(firefox等)でも同様のツールがあります。<br>
調べたいページを表示させて、キーボードの「F12」を押します。
</p>
<p>
画面の下に別枠で「デベロッパーツール」が表示されます。<br>
デベロッパーツールが開いたら左上にあるアイコンをマウスでクリックします。<br>
</p>
<p>
この状態でページ上の調べたい要素にカーソルを合わせると、該当する部分のソースコードがハイライトされます。<br>
要素をクリックするとソースコードが選択されます。
</p>
<p>
逆に、ソースコードからページ上の要素をハイライトすることもできます。
</p>


<p>
動画でみる
</p>
<video src="https://www.ad-rpm-booster.com//man/devtools.mov" controls>
</video>-->



<span><a class="hideHelpBtn">閉じる</a></span>
</div>


<div id="help-contentSelector" class="display-none">
<h3>メインコンテンツ全体についての説明</h3>
<img src="<?php echo $this->parent->plugins_url; ?>/images/help-contentSelector.png">

<p>
テーマのメインコンテンツのブロック（div,mainなどのタグ）です。パンくずリストや投稿記事、前後記事リンクを含みます。<br>
コンテンツ開始部分の日付やタイトル、コンテンツ終了部分のナビゲーション（関連記事や前後記事へのリンク）を目安に指定してください。
</p>
<p>
ワードプレスのデフォルトのテーマでは「#main」になります。<br>
※その他テーマをお使いの方は「よくある質問」に代表的なテーマの設定内容を掲載しておりますのでご参照ください。
</p>

<span><a class="hideHelpBtn">helpを閉じる</a></span>
</div>


<div id="help-itemSelector" class="display-none">
<h3>記事全体についての説明</h3>
<img src="<?php echo $this->parent->plugins_url; ?>/images/help-itemSelector.png">

<p>
記事全体のブロック（div,articleなどのタグ）です。タイトルやアイキャッチ画像、投稿記事本文を含みます。<br>
上部のパンくずリスト、日付やページ下部の関連記事や前後記事へのリンクを除いた記事のみを指定してください。
</p>
<p>
ここではclassの中で他の記事と共通で使えそうなものを探してください。（classは空白で区切られ複数指定があります）</p>
<p>以下は他の記事と比較した例になります。<br>
記事1 → 「&lt;article id="post-1305" class="post-1305 <span class="red">post</span> type-post status-draft ...」<br>
記事2 → 「&lt;article id="post-1042" class="post-1042 <span class="red">post</span> type-post3 status-draft3 ...」</p>
<p>この中で共通で使えそうなものは「post」となりますので「.post」を入力します。</p>
<p>
ワードプレスのデフォルトのテーマでは「.post」になります。<br>
※その他テーマをお使いの方は「よくある質問」に代表的なテーマの設定内容を掲載しておりますのでご参照ください。
</p>

<span><a class="hideHelpBtn">helpを閉じる</a></span>
</div>


<div id="help-itemBodySelector" class="display-none">
<h3>記事本文についての説明</h3>
<img src="<?php echo $this->parent->plugins_url; ?>/images/help-itemBodySelector.png">

<p>
記事本文のブロック（divなどのタグ）です。タイトルなど記事本文以外は含まれないようにしてください。
</p>
<p>
上記画像では「&lt;div class="entry-content"&gt;」となっていますので、「.entry-content」を入力します。<br>
idがある場合は「#the-content」と入力しても構いません。
</p>
<p>
ワードプレスのデフォルトのテーマでは「.entry-content」になります。<br>
※その他テーマをお使いの方は「よくある質問」に代表的なテーマの設定内容を掲載しておりますのでご参照ください。
</p>

<span><a class="hideHelpBtn">helpを閉じる</a></span>
</div>


<div id="help-navSelector" class="display-none">
<h3>本文下のリンクについての説明</h3>
<img src="<?php echo $this->parent->plugins_url; ?>/images/help-navSelector2.png">

<p>
前後記事へのリンクを含むブロック（div,navなどのタグ）です。<br>
関連記事へのリンクなど複数ある場合「,(カンマ)」で区切り複数指定できます。（例：「.navigation,.navigation02」）
</p>
<p>
例は本文下の前後記事へのリンクで「&lt;nav class="navigation"&gt;」となっていますので「.navigation」を指定します。
</p>
<p>
ワードプレスのデフォルトのテーマでは「.navigation」になります。<br>
※その他テーマをお使いの方は「よくある質問」に代表的なテーマの設定内容を掲載しておりますのでご参照ください。
</p>

<span><a class="hideHelpBtn">helpを閉じる</a></span>
</div>



<div id="help-navSelector3" class="display-none">
<h3>サイドバーについての説明</h3>
<img src="<?php echo $this->parent->plugins_url; ?>/images/help-navSelector3.png">

<p>
サイドバー全体のブロック（divなどのタグ）です。
</p>
<p>
例は「&lt;nav id="secondary"&gt;」となっていますので「#secondary」を指定します。
</p>
<p>
ワードプレスのデフォルトのテーマでは「#secondary」になります。<br>
※その他テーマをお使いの方は「よくある質問」に代表的なテーマの設定内容を掲載しておりますのでご参照ください。
</p>

<span><a class="hideHelpBtn">helpを閉じる</a></span>
</div>



<script id="template-page-view-list" type="text/x-tmpl">
{% var _comma=function(v){return String(v).replace(/(\d)(?=(\d\d\d)+(?!\d))/g,'$1,');}; %}
{% for (var i=0, item; item=o[i]; i++) { %}
<tr>
	<td class="date">{%=item.date%}</td>
	<td class="page_view">{%=item.page_view%}</td>
	<td class="click_num">{%=item.click_num%}</td>
	<td class="amount">{%=item.amount%}</td>
	<td class="click_rate">{%=item.click_rate%}</td>
	<td class="rpm">{%=item.rpm%}</td>
</tr>
{% } %}
</script>
